<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'include/empresa.php';
require 'include/formulario.php';
require 'include/cliente.php';
require 'include/horas.php';
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>Avance por Horas</title>
	
	<link href="css/main.css" rel="stylesheet">
	<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.10/css/jquery.dataTables.min.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.1.1/css/buttons.dataTables.min.css">
    <!-- Bootstrap -->
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
	<!--<base href="localhost/reportes">-->
	</head>
  <body>
  <nav class="navbar navbar-default">
	  <div class="container-fluid">
		<!-- Brand and toggle get grouped for better mobile display -->
		<div class="navbar-header">
		  <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
			<span class="sr-only">Toggle navigation</span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
		  </button>
		  <a class="navbar-brand" href="#">Reportes CRM ARIA++</a>
		</div>

		<!-- Collect the nav links, forms, and other content for toggling -->
		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
		  <ul class="nav navbar-nav">
			<li><a href="/reportes">Inicio</a></li>
			<li><a href="estado_cuenta.php">Estado de Cuenta </a></li>
			<li><a href="directorio.php">Directorio de Clientes</a></li>
			<li class="active"><a href="avance_horas.php">Avance por Horas<span class="sr-only">(current)</span></a></li>
		  </ul>
		</div><!-- /.navbar-collapse -->
	  </div><!-- /.container-fluid -->
	</nav>
	<div class="container">
		<div id="noprint">
	  <div class="row">
			<h1 class="col-md-12">Avance por Horas</h1>
		</div>
		<div class="row form">
			<form role="form" method="GET" action="">
				<div class="row">
					<div class="form-group col-md-6">
						<span>Compañia: </span>
						<select id="empresa" name="empresa" class="form-control">
							<option default value="">Todas</option>
							<?
							$empresas = Empresa::getAll();
							foreach($empresas as $empresa){?>
							<option value="<? echo($empresa['id_clientes']); ?>"><? echo($empresa['nombre']); ?></option>
							<?}?>
						</select>
					</div>
					<div class="form-group col-sm-6">
						<span>Tipo de Mantenimiento: </span>
						<select id="mantenimiento" name="mantenimiento" class="form-control">
							<option default value="">Todos</option>
							<option value="1">Fijo</option>
							<option value="2">Variable</option>
						</select>
					</div>
				</div>
				<div class="row">
					<div class="form-group col-md-6">
						<span>Desde: </span>
						<input name="desde" class="form-control" type="text" id="datepicker1">
					</div>
					<div class="form-group col-md-6">
						<span>Hasta: </span>
						<input name="hasta" class="form-control" type="text" id="datepicker2">
					</div>
				</div>
				<div class="row-fluid">
					<span class="col-md-5"></span>
					<input type="submit" name="submit" value="Consultar" class="col-md-2 btn btn-default" style="margin-bottom: 30px;">
					<span class="col-md-5"></span>
				</div>
			</form>
		</div>
		</div>
		<?
				if(isset($_GET['submit']) && $_GET['desde'] != "" && $_GET['hasta'] != ""){ 
					$idcliente = $_GET['empresa'];
					$desde = $_GET['desde'];
					$hasta = $_GET['hasta'];
					$mantenimiento = $_GET['mantenimiento'];
					$clientes = array();
					
					if($idcliente != ""){
						$empresas = array();
						$empresas[0]['id_clientes'] = $idcliente;
						$empresas[0]['nombre'] = Empresa::getNombre($idcliente);
					}
			?>
		<div class="row-fluid" style="margin-left: auto; margin-right: auto;">
			<div class="col-sm-12">
				<table id="avances" class="table-hover table-bordered tdcenter">
					<thead>
						<tr>
							<th rowspan="2">COMPAÑÍA</th>
							<th rowspan="2">TIPO DE MANTENIMIENTO</th>
							<th colspan="3">CONTRATO ACORDADO</th>
							<th rowspan="2">HORAS REALIZADAS</th>
							<th rowspan="2">VALOR HORAS REALIZADAS</th>
							<th rowspan="2">HORAS PENDIENTES</th>
							<th rowspan="2">VALOR HORAS PENDIENTES</th>
							<th rowspan="2">HORAS ADICIONALES</th>
							<th rowspan="2">VALOR HORAS ADICIONALES</th>
						</tr>
						<tr>
							<th>HORAS</th><th>COSTO</th><th>VALOR</th>
						</tr>
					</thead>
					<tbody>
						<?
						foreach($empresas as $empresa){
							$hmantenimiento = array();
							$hgarantia = array();
							$htotal = array();
							
							$formularios = Formulario::getEstadocuenta($empresa['id_clientes'], $desde, $hasta);
						
							foreach($formularios as $formulario){
								array_push($htotal, $formulario['tiempo_facturado']);
								if ($formulario["clasificacion_requerimiento"]==7){
									array_push($hgarantia, $formulario['tiempo_facturado']);
								}else{
									array_push($hmantenimiento, $formulario['tiempo_facturado']);
								} 
							}
							
							$hmant = Horas::Sumar($hmantenimiento);
							$cliente = Cliente::getCliente($empresa['id_clientes']);							
							
							if( !empty($cliente) ){
								$cliente = $cliente[0];								
								if($cliente['tipo_mantenimiento'] == $_GET['mantenimiento'] || $_GET['mantenimiento'] == ""){
							
						?>
							<tr>
								<td>
									<?php
										echo($empresa['nombre']);
									?>
								</td>
								<td>
									<?
										switch($cliente['tipo_mantenimiento']){
													case 1:
														echo("Fijo");
														break;
													case 2:
														echo("Variable");
														break;
													default:
														echo("Ninguno");
														break;
												}										
									?>
								</td>
								<td>
									<? 
										$hcupo = $cliente['cupo_horas'];
										if($hcupo == ""){
											$hcupo = "00:00";
										}else{
											$hcupo = $hcupo.":00";
										}
										echo($hcupo);
									?>
								</td>
								<td>
									<? 
										
										$costo = (float)$cliente['costo'];
										echo("$".$costo);
									?>
								</td>
								<td>
									<?
										$valor = (float)($hcupo * $costo);
										echo("$".$valor);
									?>
								</td>
								<td>
									<?
										$hrealizadas =Horas::Sumar($htotal);
										echo($hrealizadas);
									?>
								</td>
								<td>
									<?
										$split1 = explode(":", $hrealizadas);
										$horasrt = (int)$split1[0];
										$minrt = (int)$split1[1];
										
										$vhrealizadas = (float)($costo * $horasrt);
										$vhrealizadas += (float)($costo * (float)($minrt/60));
										
										echo("$".number_format((float)$vhrealizadas, 2, '.', ''));
									?>
								</td>
								<td>
									<?
									$horas = Horas::Adicionales($hmant, $hcupo);
									
									echo($horas['pendientes']);
								?>
								</td>
								<td>
									<?
										$split2 = explode(":", $horas['pendientes']);
										$horaspt = (int)$split2[0];
										$minpt = (int)$split2[1];
										
										$vhpendientes = (float)($costo * $horaspt);
										$vhpendientes += (float)($costo * (float)($minpt/60));
										
										echo("$".number_format((float)$vhpendientes, 2, '.', ''));
									?>
								</td>
								<td>
									<?
									echo($horas['adicionales']);
								?>
								</td>
								<td>
									<?
										$split3 = explode(":", $horas['adicionales']);
										$horasat = (int)$split3[0];
										$minat = (int)$split3[1];
										
										$vhadicionales = (float)($costo * $horasat);
										$vhadicionales += (float)($costo * (float)($minat/60));
										
										echo("$".number_format((float)$vhadicionales, 2, '.', ''));
									?>
								</td>
							</tr>
					<?php
							}
							}
							}
						?>
							<tr>
							
							</tr>
					</tbody>
				</table>	
		<?
			}
		?>

    <!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <!-- Include all compiled plugins (below), or include individual files as needed -->
    <script src="bootstrap/js/bootstrap.min.js"></script>
	<script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
	<script src="https://cdn.datatables.net/1.10.10/js/jquery.dataTables.min.js"></script>
	<script src="https://cdn.datatables.net/buttons/1.1.1/js/dataTables.buttons.min.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
	<script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/pdfmake.min.js"></script>
	<script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/vfs_fonts.js"></script>
	<script src="https://cdn.datatables.net/buttons/1.1.1/js/buttons.html5.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#formularios').DataTable({
				"order": [[ 2, "asc" ]], 
				"paging": false,
				dom: 'Bfrtip',
				language: {
					url: 'https://cdn.datatables.net/plug-ins/1.10.10/i18n/Spanish.json'
				},
				buttons: [
						'excel'
				]
			});
		} );
	</script>
	<script>
			  $(function() {
				$( "#datepicker1" ).datepicker({ dateFormat: 'yy-mm-dd' });
			  });
	</script>
	<script>
			  $(function() {
				$( "#datepicker2" ).datepicker({ dateFormat: 'yy-mm-dd' });
			  });
	</script>
  </body>
</html>